<?php
/**
 * Uninstall script for MaxBes Auto Link Manager
 * Fired when the plugin is uninstalled via WordPress admin
 *
 * @package MaxBes_Auto_Link_Manager
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Define plugin constants if not already defined
if (!defined('MAXBES_AUTOLINK_TABLE')) {
    define('MAXBES_AUTOLINK_TABLE', 'maxbes_autolink_keywords');
}

/**
 * Delete Plugin Data
 * Remove all database tables, options, and transients
 */
function maxbes_autolink_uninstall() {
    global $wpdb;

    // Drop the keywords table
    $table_name = $wpdb->prefix . MAXBES_AUTOLINK_TABLE;
    $wpdb->query("DROP TABLE IF EXISTS $table_name");

    // Delete plugin options
    delete_option('maxbes_autolink_settings');
    delete_option('maxbes_autolink_version');

    // Delete all transients/cache
    $wpdb->query(
        "DELETE FROM {$wpdb->options}
        WHERE option_name LIKE '_transient_maxbes_autolink_%'
        OR option_name LIKE '_transient_timeout_maxbes_autolink_%'"
    );

    // For multisite installations
    if (is_multisite()) {
        $blog_ids = $wpdb->get_col("SELECT blog_id FROM {$wpdb->blogs}");

        foreach ($blog_ids as $blog_id) {
            switch_to_blog($blog_id);

            // Drop table for this blog
            $table_name = $wpdb->prefix . MAXBES_AUTOLINK_TABLE;
            $wpdb->query("DROP TABLE IF EXISTS $table_name");

            // Delete options for this blog
            delete_option('maxbes_autolink_settings');
            delete_option('maxbes_autolink_version');

            // Delete transients for this blog
            $wpdb->query(
                "DELETE FROM {$wpdb->options}
                WHERE option_name LIKE '_transient_maxbes_autolink_%'
                OR option_name LIKE '_transient_timeout_maxbes_autolink_%'"
            );

            restore_current_blog();
        }
    }
}

// Run uninstall
maxbes_autolink_uninstall();
