<?php
/**
 * Plugin Name: MaxBes Auto Link Manager Lite
 * Plugin URI: https://maxbes.com/internalseo
 * Description: Free automatic internal linking with up to 50 keywords. Import from categories and tags. Upgrade to Pro for unlimited keywords and advanced features.
 * Version: 1.0.0
 * Author: MaxBes
 * Author URI: https://maxbes.com
 * Text Domain: maxbes-auto-link-manager
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('MAXBES_AUTOLINK_VERSION', '1.0.0');
define('MAXBES_AUTOLINK_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('MAXBES_AUTOLINK_PLUGIN_URL', plugin_dir_url(__FILE__));
define('MAXBES_AUTOLINK_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('MAXBES_AUTOLINK_TABLE', 'maxbes_autolink_keywords');

// Lite version limits
define('MAXBES_AUTOLINK_LITE', true);
define('MAXBES_AUTOLINK_MAX_KEYWORDS', 50);
define('MAXBES_AUTOLINK_MAX_LINKS_PER_POST', 5);
define('MAXBES_AUTOLINK_UPGRADE_URL', 'https://maxbes.com/internalseo');

/**
 * Activation Hook - Create database table and default settings
 */
function maxbes_autolink_activate() {
    require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'includes/class-autolink-activator.php';
    MaxBes_AutoLink_Activator::activate();
}
register_activation_hook(__FILE__, 'maxbes_autolink_activate');

/**
 * Deactivation Hook - Clear caches
 */
function maxbes_autolink_deactivate() {
    require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'includes/class-autolink-deactivator.php';
    MaxBes_AutoLink_Deactivator::deactivate();
}
register_deactivation_hook(__FILE__, 'maxbes_autolink_deactivate');

/**
 * Load plugin text domain for translations
 */
function maxbes_autolink_load_textdomain() {
    load_plugin_textdomain(
        'maxbes-auto-link-manager',
        false,
        dirname(MAXBES_AUTOLINK_PLUGIN_BASENAME) . '/languages'
    );
}
add_action('plugins_loaded', 'maxbes_autolink_load_textdomain');

/**
 * Initialize and run the plugin
 */
function maxbes_autolink_run() {
    // Load core files
    require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'includes/class-autolink-core.php';

    // Run the plugin
    $plugin = new MaxBes_AutoLink_Core();
    $plugin->run();
}

// Start the plugin
maxbes_autolink_run();
