<?php
/**
 * Fired during plugin deactivation
 *
 * @package MaxBes_Auto_Link_Manager
 */

if (!defined('ABSPATH')) {
    exit;
}

class MaxBes_AutoLink_Deactivator {

    /**
     * Deactivate the plugin
     * - Clear all caches
     * - Note: Does NOT delete database table (preserved for reactivation)
     */
    public static function deactivate() {
        // Clear all plugin caches
        self::clear_all_cache();

        // Flush rewrite rules
        flush_rewrite_rules();
    }

    /**
     * Clear all plugin caches
     */
    private static function clear_all_cache() {
        global $wpdb;

        // Delete all transients starting with maxbes_autolink_
        $wpdb->query(
            "DELETE FROM {$wpdb->options}
            WHERE option_name LIKE '_transient_maxbes_autolink_%'
            OR option_name LIKE '_transient_timeout_maxbes_autolink_%'"
        );
    }
}
