<?php
/**
 * Core plugin class
 * Loads all dependencies and initializes the plugin
 *
 * @package MaxBes_Auto_Link_Manager
 */

if (!defined('ABSPATH')) {
    exit;
}

class MaxBes_AutoLink_Core {

    /**
     * The loader that's responsible for maintaining and registering all hooks
     */
    protected $loader;

    /**
     * Initialize the plugin
     */
    public function __construct() {
        $this->load_dependencies();
        $this->define_admin_hooks();
        $this->define_public_hooks();
    }

    /**
     * Load required dependencies
     */
    private function load_dependencies() {
        // Database operations
        require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'includes/class-autolink-database.php';

        // Cache management
        require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'includes/class-autolink-cache.php';

        // Content processor
        require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'includes/class-autolink-processor.php';

        // Admin area
        if (is_admin()) {
            require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/class-autolink-admin.php';
            require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/class-autolink-settings.php';
            require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/class-autolink-keywords.php';
            require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/class-autolink-importer.php';
        }

        // Helper functions
        require_once MAXBES_AUTOLINK_PLUGIN_DIR . 'includes/autolink-functions.php';
    }

    /**
     * Register admin hooks
     */
    private function define_admin_hooks() {
        if (!is_admin()) {
            return;
        }

        // Initialize admin class
        $admin = new MaxBes_AutoLink_Admin();

        // Add admin menu
        add_action('admin_menu', array($admin, 'add_admin_menu'));

        // Enqueue admin assets
        add_action('admin_enqueue_scripts', array($admin, 'enqueue_admin_assets'));

        // Handle AJAX requests
        add_action('wp_ajax_maxbes_autolink_add_keyword', array($admin, 'ajax_add_keyword'));
        add_action('wp_ajax_maxbes_autolink_edit_keyword', array($admin, 'ajax_edit_keyword'));
        add_action('wp_ajax_maxbes_autolink_delete_keyword', array($admin, 'ajax_delete_keyword'));
        add_action('wp_ajax_maxbes_autolink_bulk_action', array($admin, 'ajax_bulk_action'));
        add_action('wp_ajax_maxbes_autolink_import_taxonomies', array($admin, 'ajax_import_taxonomies'));
        add_action('wp_ajax_maxbes_autolink_import_posts', array($admin, 'ajax_import_posts'));
        add_action('wp_ajax_maxbes_autolink_clear_cache', array($admin, 'ajax_clear_cache'));
    }

    /**
     * Register public/frontend hooks
     */
    private function define_public_hooks() {
        // Check if auto-linking is enabled
        $settings = get_option('maxbes_autolink_settings', array());
        if (empty($settings['enabled'])) {
            return;
        }

        // Initialize processor
        $processor = new MaxBes_AutoLink_Processor();

        // Hook into the_content filter
        add_filter('the_content', array($processor, 'process_content'), 999);
    }

    /**
     * Run the plugin
     */
    public function run() {
        // Plugin is initialized in constructor
        // This method can be used for additional runtime logic if needed
    }
}
