<?php
/**
 * Settings tab template
 *
 * @package MaxBes_Auto_Link_Manager
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get current settings
$settings = maxbes_autolink_get_settings();

// Get available taxonomies (dynamically)
$available_taxonomies = maxbes_autolink_get_available_taxonomies();

// Get available post types
$available_post_types = maxbes_autolink_get_available_post_types();

// Get selected taxonomies
$selected_taxonomies = isset($settings['selected_taxonomies']) ? $settings['selected_taxonomies'] : array();
$selected_post_types = isset($settings['selected_post_types']) ? $settings['selected_post_types'] : array('post', 'page');
?>

<div class="maxbes-settings-tab">
    <form method="post" class="maxbes-settings-form">
        <?php wp_nonce_field('maxbes_autolink_action', 'maxbes_autolink_nonce'); ?>
        <input type="hidden" name="action" value="save_settings">

        <!-- General Settings -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-admin-settings"></span> <?php _e('General Settings', 'maxbes-auto-link-manager'); ?></h2>

            <table class="form-table">
                <tr>
                    <th scope="row"><?php _e('Enable Auto-Linking', 'maxbes-auto-link-manager'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" name="enabled" value="1" <?php checked($settings['enabled'], true); ?>>
                            <?php _e('Enable automatic keyword linking', 'maxbes-auto-link-manager'); ?>
                        </label>
                        <p class="description"><?php _e('Turn this off to disable all automatic linking without deleting keywords.', 'maxbes-auto-link-manager'); ?></p>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php _e('Max Links Per Post', 'maxbes-auto-link-manager'); ?></th>
                    <td>
                        <input type="number" value="<?php echo MAXBES_AUTOLINK_MAX_LINKS_PER_POST; ?>" class="small-text" disabled readonly>
                        <p class="description">
                            <?php printf(__('Lite version is limited to %d links per post.', 'maxbes-auto-link-manager'), MAXBES_AUTOLINK_MAX_LINKS_PER_POST); ?>
                            <a href="<?php echo esc_url(MAXBES_AUTOLINK_UPGRADE_URL); ?>" target="_blank"><?php _e('Upgrade to Pro', 'maxbes-auto-link-manager'); ?></a> <?php _e('for unlimited links.', 'maxbes-auto-link-manager'); ?>
                        </p>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php _e('Case Sensitive', 'maxbes-auto-link-manager'); ?></th>
                    <td>
                        <label>
                            <input type="checkbox" name="case_sensitive" value="1" <?php checked($settings['case_sensitive'], true); ?>>
                            <?php _e('Match keywords case-sensitively', 'maxbes-auto-link-manager'); ?>
                        </label>
                        <p class="description"><?php _e('If disabled, "Dubai" will match "dubai", "DUBAI", etc.', 'maxbes-auto-link-manager'); ?></p>
                    </td>
                </tr>
            </table>
        </div>

        <!-- Taxonomy Selection (Lite: Categories & Tags Only) -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-tag"></span> <?php _e('Select Taxonomies to Use', 'maxbes-auto-link-manager'); ?></h2>
            <p class="description"><?php _e('Lite version supports Categories and Tags only. After selecting, go to the Import tab to import keywords.', 'maxbes-auto-link-manager'); ?></p>

            <div class="taxonomy-grid">
                <?php
                // Lite version: Only show categories and tags
                $lite_taxonomies = array('category', 'post_tag');
                foreach ($available_taxonomies as $taxonomy):
                    if (in_array($taxonomy['name'], $lite_taxonomies)):
                ?>
                    <label class="taxonomy-checkbox">
                        <input type="checkbox"
                               name="selected_taxonomies[]"
                               value="<?php echo esc_attr($taxonomy['name']); ?>"
                               <?php checked(in_array($taxonomy['name'], $selected_taxonomies)); ?>>
                        <strong><?php echo esc_html($taxonomy['label']); ?></strong>
                        <span class="taxonomy-info">
                            (<?php echo esc_html($taxonomy['name']); ?>)
                            - <?php echo number_format($taxonomy['count']); ?> <?php _e('terms', 'maxbes-auto-link-manager'); ?>
                        </span>
                    </label>
                <?php
                    endif;
                endforeach;
                ?>
            </div>

            <div class="notice notice-info inline" style="margin-top: 15px;">
                <p>
                    <strong><?php _e('Want to use custom taxonomies?', 'maxbes-auto-link-manager'); ?></strong>
                    <a href="<?php echo esc_url(MAXBES_AUTOLINK_UPGRADE_URL); ?>" target="_blank"><?php _e('Upgrade to Pro', 'maxbes-auto-link-manager'); ?></a>
                    <?php _e('to unlock all taxonomies including custom ones.', 'maxbes-auto-link-manager'); ?>
                </p>
            </div>
        </div>

        <!-- Post Types Selection -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-admin-post"></span> <?php _e('Select Post Types for Linking', 'maxbes-auto-link-manager'); ?></h2>
            <p class="description"><?php _e('Select which post types should have automatic links applied to their content.', 'maxbes-auto-link-manager'); ?></p>

            <?php if (!empty($available_post_types)): ?>
                <div class="taxonomy-grid">
                    <?php foreach ($available_post_types as $post_type): ?>
                        <label class="taxonomy-checkbox">
                            <input type="checkbox"
                                   name="selected_post_types[]"
                                   value="<?php echo esc_attr($post_type['name']); ?>"
                                   <?php checked(in_array($post_type['name'], $selected_post_types)); ?>>
                            <strong><?php echo esc_html($post_type['label']); ?></strong>
                            <span class="taxonomy-info">
                                (<?php echo esc_html($post_type['name']); ?>)
                                - <?php echo number_format($post_type['count']); ?> <?php _e('published', 'maxbes-auto-link-manager'); ?>
                            </span>
                        </label>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <p class="no-data"><?php _e('No public post types found.', 'maxbes-auto-link-manager'); ?></p>
            <?php endif; ?>
        </div>

        <!-- Protected Tags (Lite: Fixed) -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-shield"></span> <?php _e('Protected Tags', 'maxbes-auto-link-manager'); ?></h2>
            <p class="description"><?php _e('Keywords will NOT be linked inside these HTML tags (fixed in Lite version):', 'maxbes-auto-link-manager'); ?></p>

            <div class="protected-tags-display">
                <code>&lt;h1&gt;</code>
                <code>&lt;h2&gt;</code>
                <code>&lt;h3&gt;</code>
                <code>&lt;h4&gt;</code>
                <code>&lt;h5&gt;</code>
                <code>&lt;h6&gt;</code>
                <code>&lt;a&gt;</code>
                <code>&lt;code&gt;</code>
                <code>&lt;pre&gt;</code>
                <code>&lt;figcaption&gt;</code>
            </div>

            <div class="notice notice-info inline" style="margin-top: 15px;">
                <p>
                    <strong><?php _e('Want to customize protected tags?', 'maxbes-auto-link-manager'); ?></strong>
                    <a href="<?php echo esc_url(MAXBES_AUTOLINK_UPGRADE_URL); ?>" target="_blank"><?php _e('Upgrade to Pro', 'maxbes-auto-link-manager'); ?></a>
                    <?php _e('for full customization options.', 'maxbes-auto-link-manager'); ?>
                </p>
            </div>
        </div>

        <!-- Link Attributes (Lite: Fixed) -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-admin-links"></span> <?php _e('Link Attributes', 'maxbes-auto-link-manager'); ?></h2>
            <p class="description"><?php _e('Link attributes are fixed in Lite version:', 'maxbes-auto-link-manager'); ?></p>

            <table class="form-table">
                <tr>
                    <th scope="row"><?php _e('Link Class', 'maxbes-auto-link-manager'); ?></th>
                    <td>
                        <input type="text" value="maxbes-auto-link" class="regular-text" disabled readonly>
                    </td>
                </tr>

                <tr>
                    <th scope="row"><?php _e('Link Target', 'maxbes-auto-link-manager'); ?></th>
                    <td>
                        <input type="text" value="_self (Same Window)" class="regular-text" disabled readonly>
                    </td>
                </tr>
            </table>

            <div class="notice notice-info inline">
                <p>
                    <strong><?php _e('Need custom link attributes?', 'maxbes-auto-link-manager'); ?></strong>
                    <a href="<?php echo esc_url(MAXBES_AUTOLINK_UPGRADE_URL); ?>" target="_blank"><?php _e('Upgrade to Pro', 'maxbes-auto-link-manager'); ?></a>
                    <?php _e('to customize CSS class, target, and rel attributes.', 'maxbes-auto-link-manager'); ?>
                </p>
            </div>
        </div>

        <!-- Save Button -->
        <p class="submit">
            <button type="submit" class="button button-primary button-large">
                <span class="dashicons dashicons-yes"></span>
                <?php _e('Save Settings', 'maxbes-auto-link-manager'); ?>
            </button>
        </p>
    </form>
</div>
