<?php
/**
 * Import tab template
 *
 * @package MaxBes_Auto_Link_Manager
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get settings
$settings = maxbes_autolink_get_settings();
$selected_taxonomies = isset($settings['selected_taxonomies']) ? $settings['selected_taxonomies'] : array();
$selected_post_types = isset($settings['selected_post_types']) ? $settings['selected_post_types'] : array('post', 'page');

// Get available taxonomies
$available_taxonomies = maxbes_autolink_get_available_taxonomies();
$available_post_types = maxbes_autolink_get_available_post_types();
?>

<div class="maxbes-import-tab">

    <!-- Import from Taxonomies -->
    <div class="maxbes-card">
        <h2>
            <span class="dashicons dashicons-category"></span>
            <?php _e('Import from Taxonomies', 'maxbes-auto-link-manager'); ?>
        </h2>

        <?php if (!empty($selected_taxonomies)): ?>
            <p class="description">
                <?php _e('Import keywords from your selected taxonomies. Each term will become a keyword that links to its archive page.', 'maxbes-auto-link-manager'); ?>
            </p>

            <form method="post" class="maxbes-import-form">
                <?php wp_nonce_field('maxbes_autolink_action', 'maxbes_autolink_nonce'); ?>
                <input type="hidden" name="action" value="import_taxonomies">

                <div class="import-options">
                    <?php foreach ($selected_taxonomies as $taxonomy_name): ?>
                        <?php if (isset($available_taxonomies[$taxonomy_name])): ?>
                            <?php $taxonomy = $available_taxonomies[$taxonomy_name]; ?>
                            <label class="import-checkbox">
                                <input type="checkbox"
                                       name="import_taxonomies[]"
                                       value="<?php echo esc_attr($taxonomy['name']); ?>"
                                       checked>
                                <strong><?php echo esc_html($taxonomy['label']); ?></strong>
                                <span class="import-info">
                                    (<?php echo esc_html($taxonomy['name']); ?>)
                                    - <?php echo number_format($taxonomy['count']); ?> <?php _e('terms', 'maxbes-auto-link-manager'); ?>
                                </span>
                            </label>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>

                <p class="submit">
                    <button type="submit" class="button button-primary button-large">
                        <span class="dashicons dashicons-download"></span>
                        <?php _e('Import Selected Taxonomies', 'maxbes-auto-link-manager'); ?>
                    </button>
                </p>

                <div class="import-note">
                    <p><strong><?php _e('Note:', 'maxbes-auto-link-manager'); ?></strong></p>
                    <ul>
                        <li><?php _e('Existing keywords will not be duplicated', 'maxbes-auto-link-manager'); ?></li>
                        <li><?php _e('Priority will be set automatically based on taxonomy type', 'maxbes-auto-link-manager'); ?></li>
                        <li><?php _e('All imported keywords will be set to Active status', 'maxbes-auto-link-manager'); ?></li>
                    </ul>
                </div>
            </form>

        <?php else: ?>
            <div class="notice notice-warning inline">
                <p>
                    <strong><?php _e('No taxonomies selected!', 'maxbes-auto-link-manager'); ?></strong><br>
                    <?php _e('Please go to the Settings tab and select which taxonomies you want to use for automatic linking.', 'maxbes-auto-link-manager'); ?>
                </p>
                <p>
                    <a href="?page=maxbes-autolink&tab=settings" class="button button-primary">
                        <?php _e('Go to Settings', 'maxbes-auto-link-manager'); ?>
                    </a>
                </p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Import from Posts/Pages -->
    <div class="maxbes-card">
        <h2>
            <span class="dashicons dashicons-admin-post"></span>
            <?php _e('Import from Posts & Pages', 'maxbes-auto-link-manager'); ?>
        </h2>

        <?php if (!empty($selected_post_types)): ?>
            <p class="description">
                <?php _e('Import keywords from your posts and pages. Each post/page title will become a keyword that links to that content.', 'maxbes-auto-link-manager'); ?>
            </p>

            <form method="post" class="maxbes-import-form">
                <?php wp_nonce_field('maxbes_autolink_action', 'maxbes_autolink_nonce'); ?>
                <input type="hidden" name="action" value="import_posts">

                <div class="import-options">
                    <?php foreach ($selected_post_types as $post_type_name): ?>
                        <?php if (isset($available_post_types[$post_type_name])): ?>
                            <?php $post_type = $available_post_types[$post_type_name]; ?>
                            <label class="import-checkbox">
                                <input type="checkbox"
                                       name="import_post_types[]"
                                       value="<?php echo esc_attr($post_type['name']); ?>"
                                       checked>
                                <strong><?php echo esc_html($post_type['label']); ?></strong>
                                <span class="import-info">
                                    (<?php echo esc_html($post_type['name']); ?>)
                                    - <?php echo number_format($post_type['count']); ?> <?php _e('published', 'maxbes-auto-link-manager'); ?>
                                </span>
                            </label>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>

                <p class="submit">
                    <button type="submit" class="button button-primary button-large">
                        <span class="dashicons dashicons-download"></span>
                        <?php _e('Import Selected Post Types', 'maxbes-auto-link-manager'); ?>
                    </button>
                </p>

                <div class="import-note">
                    <p><strong><?php _e('Note:', 'maxbes-auto-link-manager'); ?></strong></p>
                    <ul>
                        <li><?php _e('Only published content will be imported', 'maxbes-auto-link-manager'); ?></li>
                        <li><?php _e('Post/page titles will be used as keywords', 'maxbes-auto-link-manager'); ?></li>
                        <li><?php _e('Existing keywords will not be duplicated', 'maxbes-auto-link-manager'); ?></li>
                        <li><?php _e('This may take a while for large sites', 'maxbes-auto-link-manager'); ?></li>
                    </ul>
                </div>
            </form>

        <?php else: ?>
            <div class="notice notice-warning inline">
                <p>
                    <strong><?php _e('No post types selected!', 'maxbes-auto-link-manager'); ?></strong><br>
                    <?php _e('Please go to the Settings tab and select which post types you want to import from.', 'maxbes-auto-link-manager'); ?>
                </p>
                <p>
                    <a href="?page=maxbes-autolink&tab=settings" class="button button-primary">
                        <?php _e('Go to Settings', 'maxbes-auto-link-manager'); ?>
                    </a>
                </p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Import Tips -->
    <div class="maxbes-card maxbes-import-tips">
        <h2>
            <span class="dashicons dashicons-lightbulb"></span>
            <?php _e('Import Tips & Best Practices', 'maxbes-auto-link-manager'); ?>
        </h2>

        <div class="tips-grid">
            <div class="tip-item">
                <span class="tip-icon">🎯</span>
                <h3><?php _e('Start with Taxonomies', 'maxbes-auto-link-manager'); ?></h3>
                <p><?php _e('Import from taxonomies first (categories, tags, custom taxonomies) as they are typically more important for internal linking.', 'maxbes-auto-link-manager'); ?></p>
            </div>

            <div class="tip-item">
                <span class="tip-icon">⚡</span>
                <h3><?php _e('Priority Matters', 'maxbes-auto-link-manager'); ?></h3>
                <p><?php _e('Taxonomies get higher priority than posts. Property-related taxonomies get priority 1, categories/tags get priority 2-3, and posts get priority 4-5.', 'maxbes-auto-link-manager'); ?></p>
            </div>

            <div class="tip-item">
                <span class="tip-icon">🔄</span>
                <h3><?php _e('Re-Import Anytime', 'maxbes-auto-link-manager'); ?></h3>
                <p><?php _e('You can safely re-import at any time. Existing keywords will not be duplicated, only new ones will be added.', 'maxbes-auto-link-manager'); ?></p>
            </div>

            <div class="tip-item">
                <span class="tip-icon">✏️</span>
                <h3><?php _e('Review & Edit', 'maxbes-auto-link-manager'); ?></h3>
                <p><?php _e('After importing, go to the Keywords tab to review and adjust priorities, max links, or disable specific keywords.', 'maxbes-auto-link-manager'); ?></p>
            </div>

            <div class="tip-item">
                <span class="tip-icon">🚀</span>
                <h3><?php _e('Clear Cache After Import', 'maxbes-auto-link-manager'); ?></h3>
                <p><?php _e('Cache is automatically cleared after import, but you can manually clear it from the Dashboard if needed.', 'maxbes-auto-link-manager'); ?></p>
            </div>

            <div class="tip-item">
                <span class="tip-icon">📊</span>
                <h3><?php _e('Monitor Performance', 'maxbes-auto-link-manager'); ?></h3>
                <p><?php _e('Check the Dashboard to see statistics about your imported keywords and how they are distributed.', 'maxbes-auto-link-manager'); ?></p>
            </div>
        </div>
    </div>
</div>
