<?php
/**
 * Dashboard tab template
 *
 * @package MaxBes_Auto_Link_Manager
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get statistics
$stats = MaxBes_AutoLink_Database::get_statistics();
$settings = maxbes_autolink_get_settings();
?>

<div class="maxbes-dashboard">
    <div class="maxbes-dashboard-grid">

        <!-- Statistics Overview -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-chart-bar"></span> <?php _e('Statistics Overview', 'maxbes-auto-link-manager'); ?></h2>

            <div class="maxbes-stats-grid">
                <div class="stat-box stat-total">
                    <div class="stat-value"><?php echo number_format($stats['total']); ?></div>
                    <div class="stat-label"><?php _e('Total Keywords', 'maxbes-auto-link-manager'); ?></div>
                </div>

                <div class="stat-box stat-active">
                    <div class="stat-value"><?php echo number_format($stats['active']); ?></div>
                    <div class="stat-label"><?php _e('Active Keywords', 'maxbes-auto-link-manager'); ?></div>
                </div>

                <div class="stat-box stat-inactive">
                    <div class="stat-value"><?php echo number_format($stats['inactive']); ?></div>
                    <div class="stat-label"><?php _e('Inactive Keywords', 'maxbes-auto-link-manager'); ?></div>
                </div>
            </div>

            <!-- Status -->
            <div class="maxbes-status-indicator">
                <?php if ($settings['enabled']): ?>
                    <span class="status-badge status-active">
                        <span class="dashicons dashicons-yes-alt"></span>
                        <?php _e('Auto-Linking Active', 'maxbes-auto-link-manager'); ?>
                    </span>
                <?php else: ?>
                    <span class="status-badge status-inactive">
                        <span class="dashicons dashicons-dismiss"></span>
                        <?php _e('Auto-Linking Disabled', 'maxbes-auto-link-manager'); ?>
                    </span>
                <?php endif; ?>
            </div>
        </div>

        <!-- Keywords by Type -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-category"></span> <?php _e('Keywords by Type', 'maxbes-auto-link-manager'); ?></h2>

            <?php if (!empty($stats['by_type'])): ?>
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php _e('Type', 'maxbes-auto-link-manager'); ?></th>
                            <th><?php _e('Count', 'maxbes-auto-link-manager'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['by_type'] as $type): ?>
                            <tr>
                                <td><strong><?php echo esc_html(ucfirst($type->link_type)); ?></strong></td>
                                <td><?php echo number_format($type->count); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="no-data"><?php _e('No keywords yet.', 'maxbes-auto-link-manager'); ?></p>
            <?php endif; ?>
        </div>

        <!-- Keywords by Source -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-tag"></span> <?php _e('Keywords by Source', 'maxbes-auto-link-manager'); ?></h2>

            <?php if (!empty($stats['by_source'])): ?>
                <table class="widefat">
                    <thead>
                        <tr>
                            <th><?php _e('Source', 'maxbes-auto-link-manager'); ?></th>
                            <th><?php _e('Count', 'maxbes-auto-link-manager'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['by_source'] as $source): ?>
                            <tr>
                                <td><strong><?php echo esc_html($source->source_type); ?></strong></td>
                                <td><?php echo number_format($source->count); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="no-data"><?php _e('No source data available.', 'maxbes-auto-link-manager'); ?></p>
            <?php endif; ?>
        </div>

        <!-- Upgrade to Pro -->
        <div class="maxbes-card" style="background: linear-to-br, #f7fafc, #e6f2ff); border: 2px solid #3182ce;">
            <h2><span class="dashicons dashicons-star-filled" style="color: #3182ce;"></span> <?php _e('Upgrade to Pro', 'maxbes-auto-link-manager'); ?></h2>

            <div class="upgrade-info">
                <p><strong><?php _e('Lite Version Limitations:', 'maxbes-auto-link-manager'); ?></strong></p>
                <ul style="margin: 15px 0; padding-left: 20px;">
                    <li><?php printf(__('Using %d of %d keywords', 'maxbes-auto-link-manager'), $stats['total'], MAXBES_AUTOLINK_MAX_KEYWORDS); ?></li>
                    <li><?php printf(__('Limited to %d links per post', 'maxbes-auto-link-manager'), MAXBES_AUTOLINK_MAX_LINKS_PER_POST); ?></li>
                    <li><?php _e('No advanced caching', 'maxbes-auto-link-manager'); ?></li>
                    <li><?php _e('Categories & tags only', 'maxbes-auto-link-manager'); ?></li>
                </ul>

                <p><strong><?php _e('Pro Version Includes:', 'maxbes-auto-link-manager'); ?></strong></p>
                <ul style="margin: 15px 0; padding-left: 20px; color: #2d5aa0;">
                    <li>✅ <?php _e('Unlimited keywords & links', 'maxbes-auto-link-manager'); ?></li>
                    <li>✅ <?php _e('Advanced 24h caching', 'maxbes-auto-link-manager'); ?></li>
                    <li>✅ <?php _e('All taxonomies & post types', 'maxbes-auto-link-manager'); ?></li>
                    <li>✅ <?php _e('Priority system & bulk operations', 'maxbes-auto-link-manager'); ?></li>
                </ul>

                <a href="<?php echo esc_url(MAXBES_AUTOLINK_UPGRADE_URL); ?>" class="button button-primary" target="_blank" style="margin-top: 10px;">
                    <span class="dashicons dashicons-cart"></span>
                    <?php _e('Upgrade to Pro', 'maxbes-auto-link-manager'); ?>
                </a>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="maxbes-card maxbes-quick-actions">
            <h2><span class="dashicons dashicons-admin-tools"></span> <?php _e('Quick Actions', 'maxbes-auto-link-manager'); ?></h2>

            <div class="action-buttons">
                <a href="?page=maxbes-autolink&tab=keywords" class="button button-primary">
                    <span class="dashicons dashicons-plus-alt"></span>
                    <?php _e('Add New Keyword', 'maxbes-auto-link-manager'); ?>
                </a>

                <a href="?page=maxbes-autolink&tab=import" class="button button-secondary">
                    <span class="dashicons dashicons-upload"></span>
                    <?php _e('Import Keywords', 'maxbes-auto-link-manager'); ?>
                </a>

                <a href="?page=maxbes-autolink&tab=settings" class="button button-secondary">
                    <span class="dashicons dashicons-admin-settings"></span>
                    <?php _e('Configure Settings', 'maxbes-auto-link-manager'); ?>
                </a>
            </div>
        </div>

        <!-- Help & Documentation -->
        <div class="maxbes-card">
            <h2><span class="dashicons dashicons-info"></span> <?php _e('Help & Documentation', 'maxbes-auto-link-manager'); ?></h2>

            <div class="help-content">
                <h3><?php _e('How to Use:', 'maxbes-auto-link-manager'); ?></h3>
                <ol>
                    <li><?php _e('Go to <strong>Settings</strong> tab and select which taxonomies you want to use', 'maxbes-auto-link-manager'); ?></li>
                    <li><?php _e('Go to <strong>Import</strong> tab to automatically import keywords from your selected taxonomies', 'maxbes-auto-link-manager'); ?></li>
                    <li><?php _e('Or manually add keywords in the <strong>Keywords</strong> tab', 'maxbes-auto-link-manager'); ?></li>
                    <li><?php _e('Keywords will automatically link in your posts based on priority and settings', 'maxbes-auto-link-manager'); ?></li>
                </ol>

                <h3><?php _e('Lite Features:', 'maxbes-auto-link-manager'); ?></h3>
                <ul>
                    <li>✅ <?php _e('Up to 50 keywords', 'maxbes-auto-link-manager'); ?></li>
                    <li>✅ <?php _e('5 links per post maximum', 'maxbes-auto-link-manager'); ?></li>
                    <li>✅ <?php _e('Categories & tags import', 'maxbes-auto-link-manager'); ?></li>
                    <li>✅ <?php _e('Protected tags (skip headings, links, code)', 'maxbes-auto-link-manager'); ?></li>
                    <li>✅ <?php _e('Universal - Works with any theme', 'maxbes-auto-link-manager'); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>
