<?php
/**
 * Main admin page template
 *
 * @package MaxBes_Auto_Link_Manager
 */

if (!defined('ABSPATH')) {
    exit;
}

// Get current tab
$current_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'dashboard';

// Display admin notices
$notice = get_transient('maxbes_autolink_admin_notice');
if ($notice) {
    delete_transient('maxbes_autolink_admin_notice');
    ?>
    <div class="notice notice-<?php echo esc_attr($notice['type']); ?> is-dismissible">
        <p><?php echo esc_html($notice['message']); ?></p>
    </div>
    <?php
}
?>

<div class="wrap maxbes-autolink-wrap">
    <h1 class="wp-heading-inline">
        <?php _e('MaxBes Auto Link Manager', 'maxbes-auto-link-manager'); ?>
    </h1>
    <span class="maxbes-version">v<?php echo MAXBES_AUTOLINK_VERSION; ?></span>

    <hr class="wp-header-end">

    <!-- Tabs Navigation -->
    <nav class="nav-tab-wrapper">
        <a href="?page=maxbes-autolink&tab=dashboard" class="nav-tab <?php echo $current_tab === 'dashboard' ? 'nav-tab-active' : ''; ?>">
            <span class="dashicons dashicons-dashboard"></span>
            <?php _e('Dashboard', 'maxbes-auto-link-manager'); ?>
        </a>
        <a href="?page=maxbes-autolink&tab=keywords" class="nav-tab <?php echo $current_tab === 'keywords' ? 'nav-tab-active' : ''; ?>">
            <span class="dashicons dashicons-admin-links"></span>
            <?php _e('Keywords', 'maxbes-auto-link-manager'); ?>
        </a>
        <a href="?page=maxbes-autolink&tab=import" class="nav-tab <?php echo $current_tab === 'import' ? 'nav-tab-active' : ''; ?>">
            <span class="dashicons dashicons-upload"></span>
            <?php _e('Import', 'maxbes-auto-link-manager'); ?>
        </a>
        <a href="?page=maxbes-autolink&tab=settings" class="nav-tab <?php echo $current_tab === 'settings' ? 'nav-tab-active' : ''; ?>">
            <span class="dashicons dashicons-admin-settings"></span>
            <?php _e('Settings', 'maxbes-auto-link-manager'); ?>
        </a>
    </nav>

    <!-- Tab Content -->
    <div class="maxbes-tab-content">
        <?php
        switch ($current_tab) {
            case 'dashboard':
                include MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/views/dashboard-tab.php';
                break;

            case 'keywords':
                include MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/views/keywords-tab.php';
                break;

            case 'import':
                include MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/views/import-tab.php';
                break;

            case 'settings':
                include MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/views/settings-tab.php';
                break;

            default:
                include MAXBES_AUTOLINK_PLUGIN_DIR . 'admin/views/dashboard-tab.php';
        }
        ?>
    </div>
</div>
